// Iestatīt power-up opcijas un īpašības
// oTitle_Menu Izveides notikums
powerUps = [
    { name: "Jump Boost", icon: sJumpBoostIcon, effect: function() { global.jspd[0] = -10; } },
    { name: "Speed Boost", icon: sDoubleSpeedIcon, effect: function() { global.moveSpd *= 2; } },
    { name: "Bounce Boost", icon: sBounceBoostIcon, effect: function() { global.bounceBack = 1.2; } },
    { name: "Dash", icon: sDashIcon, effect: function() { global.canDash = true; } },
    // Pievienot vairāk power-upus šeit
];

// Pārliecinieties, ka global.powerUps ir pareizi inicializēts
if (!variable_global_exists("powerUps") || !is_array(global.powerUps) || array_length(global.powerUps) != array_length(powerUps)) {
    global.powerUps = array_create(array_length(powerUps), 0); // Inicializēt masīvu ar nullēm
}

// Inicializēt selectedPowerUps
if (!variable_global_exists("selectedPowerUps")) {
    global.selectedPowerUps = ds_list_create();
}
else {
    ds_list_clear(global.selectedPowerUps);
}

// Izveidot pieejamo power-upu sarakstu (izslēdzot jau savāktos)
var availablePowerUps = ds_list_create();
for (var i = 0; i < array_length(powerUps); i++) {
    if (global.powerUps[i] != 1) {
        ds_list_add(availablePowerUps, i);
    }
}

// Nejauši izvēlēties divus power-upus no pieejamajiem
if (ds_list_size(availablePowerUps) == 0) {
    ds_list_add(global.selectedPowerUps, -1); // Pievienot aizvietotāju "Nav power-upu atlikušos!"
} else {
    while (ds_list_size(global.selectedPowerUps) < 2 && ds_list_size(availablePowerUps) > 0) {
        var randomIndex = ds_list_find_value(availablePowerUps, irandom(ds_list_size(availablePowerUps) - 1));
        ds_list_add(global.selectedPowerUps, randomIndex);
        ds_list_delete(availablePowerUps, ds_list_find_index(availablePowerUps, randomIndex));
    }
}

ds_list_add(global.selectedPowerUps, -2); // Pievienot "Atpakaļ" opciju
ds_list_destroy(availablePowerUps); // Tīrīt pagaidu sarakstu

width = 64;
height = 104;
last_selected = 0;
op_border = 8;
op_space = 16;
pos = 0;

op_length = ds_list_size(global.selectedPowerUps); // Dinamiski iegūstam izvēlēto power-upu un "Atpakaļ" opcijas skaitu
menu_active = false;
x = 0;
y = 0;
pause = false;
